/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portablegit.win32;

import com.aptana.portablegit.win32.Extractor;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class PortableGitPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.portablegit.win32";
    private static PortableGitPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if ("win32".equals(Platform.getOS())) {
            this.checkOrInstallGit();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void checkOrInstallGit() {
        try {
            IPath path = this.getStateLocation();
            IPath installed = path.append(".installed_" + this.getBundle().getVersion().toString());
            if (!installed.toFile().exists()) {
                path.toFile().mkdirs();
                if (Extractor.extract(path)) {
                    installed.toFile().createNewFile();
                }
            }
        }
        catch (IOException e) {
            PortableGitPlugin.log(e);
        }
    }

    public static PortableGitPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        PortableGitPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getLocalizedMessage(), e));
    }

    public static void log(String msg) {
        PortableGitPlugin.log((IStatus)new Status(1, PLUGIN_ID, 0, msg, null));
    }

    public static void log(IStatus status) {
        PortableGitPlugin.getDefault().getLog().log(status);
    }
}

